using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class CustomersBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            //
            //CustomersBO
            //'
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[cust_pk],[cust_Company],[cust_Prefix],[cust_FirstName],[cust_MiddleName],[cust_LastName],[cust_Suffix],[cust_Address1],[cust_Address2],[cust_City],[cust_State],[cust_Postal],[cust_Country],[cust_Email],[cust_PhoneDay],[cust_PhoneDayType],[cust_PhoneNight],[cust_PhoneNightType],[cust_Created],[cust_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "cust_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "Customers";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("cust_pk", typeof(System.Int32)),
new DataColumn("cust_Company", typeof(System.String)),
new DataColumn("cust_Prefix", typeof(System.String)),
new DataColumn("cust_FirstName", typeof(System.String)),
new DataColumn("cust_MiddleName", typeof(System.String)),
new DataColumn("cust_LastName", typeof(System.String)),
new DataColumn("cust_Suffix", typeof(System.String)),
new DataColumn("cust_Address1", typeof(System.String)),
new DataColumn("cust_Address2", typeof(System.String)),
new DataColumn("cust_City", typeof(System.String)),
new DataColumn("cust_State", typeof(System.String)),
new DataColumn("cust_Postal", typeof(System.String)),
new DataColumn("cust_Country", typeof(System.String)),
new DataColumn("cust_Email", typeof(System.String)),
new DataColumn("cust_PhoneDay", typeof(System.String)),
new DataColumn("cust_PhoneDayType", typeof(System.Int32)),
new DataColumn("cust_PhoneNight", typeof(System.String)),
new DataColumn("cust_PhoneNightType", typeof(System.Int32)),
new DataColumn("cust_Created", typeof(System.DateTime)),
new DataColumn("cust_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(CustomersBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(CustomersBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cust_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["cust_pk"];
            }
            set
            {
                this.CurrentRow["cust_pk"] = value;
            }
        }

        /// <summary>
        /// Customer company name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer company name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Company
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Company"];
            }
            set
            {
                this.CurrentRow["cust_Company"] = value;
            }
        }

        /// <summary>
        /// Customer Name Prefix
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Name Prefix"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Prefix
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Prefix"];
            }
            set
            {
                this.CurrentRow["cust_Prefix"] = value;
            }
        }

        /// <summary>
        /// Customer First Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer First Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_FirstName
        {
            get
            {
                return (System.String)this.CurrentRow["cust_FirstName"];
            }
            set
            {
                this.CurrentRow["cust_FirstName"] = value;
            }
        }

        /// <summary>
        /// Customer Middle Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Middle Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_MiddleName
        {
            get
            {
                return (System.String)this.CurrentRow["cust_MiddleName"];
            }
            set
            {
                this.CurrentRow["cust_MiddleName"] = value;
            }
        }

        /// <summary>
        /// Customer Last Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Last Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_LastName
        {
            get
            {
                return (System.String)this.CurrentRow["cust_LastName"];
            }
            set
            {
                this.CurrentRow["cust_LastName"] = value;
            }
        }

        /// <summary>
        /// Customer Name Suffix
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Name Suffix"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Suffix
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Suffix"];
            }
            set
            {
                this.CurrentRow["cust_Suffix"] = value;
            }
        }

        /// <summary>
        /// Customer Address Line 1
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Address Line 1"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Address1
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Address1"];
            }
            set
            {
                this.CurrentRow["cust_Address1"] = value;
            }
        }

        /// <summary>
        /// Customer Address Line 2
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Address Line 2"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Address2
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Address2"];
            }
            set
            {
                this.CurrentRow["cust_Address2"] = value;
            }
        }

        /// <summary>
        /// Customer City
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer City"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_City
        {
            get
            {
                return (System.String)this.CurrentRow["cust_City"];
            }
            set
            {
                this.CurrentRow["cust_City"] = value;
            }
        }

        /// <summary>
        /// Customer State or Region
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer State or Region"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_State
        {
            get
            {
                return (System.String)this.CurrentRow["cust_State"];
            }
            set
            {
                this.CurrentRow["cust_State"] = value;
            }
        }

        /// <summary>
        /// Customer Postal Code
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Postal Code"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Postal
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Postal"];
            }
            set
            {
                this.CurrentRow["cust_Postal"] = value;
            }
        }

        /// <summary>
        /// Customer Country
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Country"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Country
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Country"];
            }
            set
            {
                this.CurrentRow["cust_Country"] = value;
            }
        }

        /// <summary>
        /// Customer Email Address
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Email Address"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_Email
        {
            get
            {
                return (System.String)this.CurrentRow["cust_Email"];
            }
            set
            {
                this.CurrentRow["cust_Email"] = value;
            }
        }

        /// <summary>
        /// Customer Day Phone
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Day Phone"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_PhoneDay
        {
            get
            {
                return (System.String)this.CurrentRow["cust_PhoneDay"];
            }
            set
            {
                this.CurrentRow["cust_PhoneDay"] = value;
            }
        }

        /// <summary>
        /// Customer Day Phone Type
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Day Phone Type"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public PhoneType cust_PhoneDayType
        {
            get
            {
                return (PhoneType)this.CurrentRow["cust_PhoneDayType"];
            }
            set
            {
                this.CurrentRow["cust_PhoneDayType"] = value;
            }
        }

        /// <summary>
        /// Customer Night Phone
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Night Phone"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cust_PhoneNight
        {
            get
            {
                return (System.String)this.CurrentRow["cust_PhoneNight"];
            }
            set
            {
                this.CurrentRow["cust_PhoneNight"] = value;
            }
        }

        /// <summary>
        /// Customer Night Phone Type
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Customer Night Phone Type"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public PhoneType cust_PhoneNightType
        {
            get
            {
                return (PhoneType)this.CurrentRow["cust_PhoneNightType"];
            }
            set
            {
                this.CurrentRow["cust_PhoneNightType"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime cust_Created
        {
            get
            {
                return (System.DateTime)this.CurrentRow["cust_Created"];
            }
            set
            {
                this.CurrentRow["cust_Created"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cust_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["cust_Version"];
            }
            set
            {
                this.CurrentRow["cust_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum CustomersBOFieldNames
        {
            cust_pk,
            cust_Company,
            cust_Prefix,
            cust_FirstName,
            cust_MiddleName,
            cust_LastName,
            cust_Suffix,
            cust_Address1,
            cust_Address2,
            cust_City,
            cust_State,
            cust_Postal,
            cust_Country,
            cust_Email,
            cust_PhoneDay,
            cust_PhoneDayType,
            cust_PhoneNight,
            cust_PhoneNightType,
            cust_Created,
            cust_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CustomersBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<CustomersBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<CustomersBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<CustomersBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the CustomersBO class.
        /// </summary>
        static CustomersBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(25);
            _PropertyDescriptors.Add("cust_pk", new FieldDescriptor(CustomersBOFieldNames.cust_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("cust_Company", new FieldDescriptor(CustomersBOFieldNames.cust_Company, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Prefix", new FieldDescriptor(CustomersBOFieldNames.cust_Prefix, typeof(System.String)));
            _PropertyDescriptors.Add("cust_FirstName", new FieldDescriptor(CustomersBOFieldNames.cust_FirstName, typeof(System.String)));
            _PropertyDescriptors.Add("cust_MiddleName", new FieldDescriptor(CustomersBOFieldNames.cust_MiddleName, typeof(System.String)));
            _PropertyDescriptors.Add("cust_LastName", new FieldDescriptor(CustomersBOFieldNames.cust_LastName, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Suffix", new FieldDescriptor(CustomersBOFieldNames.cust_Suffix, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Address1", new FieldDescriptor(CustomersBOFieldNames.cust_Address1, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Address2", new FieldDescriptor(CustomersBOFieldNames.cust_Address2, typeof(System.String)));
            _PropertyDescriptors.Add("cust_City", new FieldDescriptor(CustomersBOFieldNames.cust_City, typeof(System.String)));
            _PropertyDescriptors.Add("cust_State", new FieldDescriptor(CustomersBOFieldNames.cust_State, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Postal", new FieldDescriptor(CustomersBOFieldNames.cust_Postal, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Country", new FieldDescriptor(CustomersBOFieldNames.cust_Country, typeof(System.String)));
            _PropertyDescriptors.Add("cust_Email", new FieldDescriptor(CustomersBOFieldNames.cust_Email, typeof(System.String)));
            _PropertyDescriptors.Add("cust_PhoneDay", new FieldDescriptor(CustomersBOFieldNames.cust_PhoneDay, typeof(System.String)));
            _PropertyDescriptors.Add("cust_PhoneDayType", new FieldDescriptor(CustomersBOFieldNames.cust_PhoneDayType, typeof(PhoneType)));
            _PropertyDescriptors.Add("cust_PhoneNight", new FieldDescriptor(CustomersBOFieldNames.cust_PhoneNight, typeof(System.String)));
            _PropertyDescriptors.Add("cust_PhoneNightType", new FieldDescriptor(CustomersBOFieldNames.cust_PhoneNightType, typeof(PhoneType)));
            _PropertyDescriptors.Add("cust_Created", new FieldDescriptor(CustomersBOFieldNames.cust_Created, typeof(System.DateTime)));
            _PropertyDescriptors.Add("cust_Version", new FieldDescriptor(CustomersBOFieldNames.cust_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(20);
            _AllFieldsList.Add("cust_pk");
            _AllFieldsList.Add("cust_Company");
            _AllFieldsList.Add("cust_Prefix");
            _AllFieldsList.Add("cust_FirstName");
            _AllFieldsList.Add("cust_MiddleName");
            _AllFieldsList.Add("cust_LastName");
            _AllFieldsList.Add("cust_Suffix");
            _AllFieldsList.Add("cust_Address1");
            _AllFieldsList.Add("cust_Address2");
            _AllFieldsList.Add("cust_City");
            _AllFieldsList.Add("cust_State");
            _AllFieldsList.Add("cust_Postal");
            _AllFieldsList.Add("cust_Country");
            _AllFieldsList.Add("cust_Email");
            _AllFieldsList.Add("cust_PhoneDay");
            _AllFieldsList.Add("cust_PhoneDayType");
            _AllFieldsList.Add("cust_PhoneNight");
            _AllFieldsList.Add("cust_PhoneNightType");
            _AllFieldsList.Add("cust_Created");
            _AllFieldsList.Add("cust_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(20);
            _FieldDbTypes.Add("cust_pk", DbType.Int32);
            _FieldDbTypes.Add("cust_Company", DbType.String);
            _FieldDbTypes.Add("cust_Prefix", DbType.String);
            _FieldDbTypes.Add("cust_FirstName", DbType.String);
            _FieldDbTypes.Add("cust_MiddleName", DbType.String);
            _FieldDbTypes.Add("cust_LastName", DbType.String);
            _FieldDbTypes.Add("cust_Suffix", DbType.String);
            _FieldDbTypes.Add("cust_Address1", DbType.String);
            _FieldDbTypes.Add("cust_Address2", DbType.String);
            _FieldDbTypes.Add("cust_City", DbType.String);
            _FieldDbTypes.Add("cust_State", DbType.String);
            _FieldDbTypes.Add("cust_Postal", DbType.AnsiString);
            _FieldDbTypes.Add("cust_Country", DbType.String);
            _FieldDbTypes.Add("cust_Email", DbType.AnsiString);
            _FieldDbTypes.Add("cust_PhoneDay", DbType.AnsiString);
            _FieldDbTypes.Add("cust_PhoneDayType", DbType.Int32);
            _FieldDbTypes.Add("cust_PhoneNight", DbType.AnsiString);
            _FieldDbTypes.Add("cust_PhoneNightType", DbType.Int32);
            _FieldDbTypes.Add("cust_Created", DbType.DateTime);
            _FieldDbTypes.Add("cust_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(21);
            _FieldEnums.Add("cust_pk", CustomersBOFieldNames.cust_pk);
            _FieldEnums.Add("cust_Company", CustomersBOFieldNames.cust_Company);
            _FieldEnums.Add("cust_Prefix", CustomersBOFieldNames.cust_Prefix);
            _FieldEnums.Add("cust_FirstName", CustomersBOFieldNames.cust_FirstName);
            _FieldEnums.Add("cust_MiddleName", CustomersBOFieldNames.cust_MiddleName);
            _FieldEnums.Add("cust_LastName", CustomersBOFieldNames.cust_LastName);
            _FieldEnums.Add("cust_Suffix", CustomersBOFieldNames.cust_Suffix);
            _FieldEnums.Add("cust_Address1", CustomersBOFieldNames.cust_Address1);
            _FieldEnums.Add("cust_Address2", CustomersBOFieldNames.cust_Address2);
            _FieldEnums.Add("cust_City", CustomersBOFieldNames.cust_City);
            _FieldEnums.Add("cust_State", CustomersBOFieldNames.cust_State);
            _FieldEnums.Add("cust_Postal", CustomersBOFieldNames.cust_Postal);
            _FieldEnums.Add("cust_Country", CustomersBOFieldNames.cust_Country);
            _FieldEnums.Add("cust_Email", CustomersBOFieldNames.cust_Email);
            _FieldEnums.Add("cust_PhoneDay", CustomersBOFieldNames.cust_PhoneDay);
            _FieldEnums.Add("cust_PhoneDayType", CustomersBOFieldNames.cust_PhoneDayType);
            _FieldEnums.Add("cust_PhoneNight", CustomersBOFieldNames.cust_PhoneNight);
            _FieldEnums.Add("cust_PhoneNightType", CustomersBOFieldNames.cust_PhoneNightType);
            _FieldEnums.Add("cust_Created", CustomersBOFieldNames.cust_Created);
            _FieldEnums.Add("cust_Version", CustomersBOFieldNames.cust_Version);
            _FieldEnums.Add("CUSTOM_FIELD", CustomersBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(20);
            _FieldLengths.Add("cust_pk", 4);
            _FieldLengths.Add("cust_Company", 150);
            _FieldLengths.Add("cust_Prefix", 20);
            _FieldLengths.Add("cust_FirstName", 60);
            _FieldLengths.Add("cust_MiddleName", 60);
            _FieldLengths.Add("cust_LastName", 60);
            _FieldLengths.Add("cust_Suffix", 20);
            _FieldLengths.Add("cust_Address1", 150);
            _FieldLengths.Add("cust_Address2", 150);
            _FieldLengths.Add("cust_City", 60);
            _FieldLengths.Add("cust_State", 128);
            _FieldLengths.Add("cust_Postal", 20);
            _FieldLengths.Add("cust_Country", 120);
            _FieldLengths.Add("cust_Email", 100);
            _FieldLengths.Add("cust_PhoneDay", 20);
            _FieldLengths.Add("cust_PhoneDayType", 4);
            _FieldLengths.Add("cust_PhoneNight", 20);
            _FieldLengths.Add("cust_PhoneNightType", 4);
            _FieldLengths.Add("cust_Created", 8);
            _FieldLengths.Add("cust_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(20);
            _FieldNativeDbTypes.Add("cust_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cust_Company", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Prefix", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_FirstName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_MiddleName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_LastName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Suffix", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Address1", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Address2", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_City", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_State", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Postal", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cust_Country", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cust_Email", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cust_PhoneDay", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cust_PhoneDayType", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cust_PhoneNight", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cust_PhoneNightType", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cust_Created", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("cust_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(20);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the CustomersBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<CustomersBOFieldNames>
        {
            public FieldDescriptor(CustomersBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(CustomersBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case CustomersBOFieldNames.cust_pk:
                        return ((CustomersBO)component).cust_pk;
                    case CustomersBOFieldNames.cust_Company:
                        return ((CustomersBO)component).cust_Company;
                    case CustomersBOFieldNames.cust_Prefix:
                        return ((CustomersBO)component).cust_Prefix;
                    case CustomersBOFieldNames.cust_FirstName:
                        return ((CustomersBO)component).cust_FirstName;
                    case CustomersBOFieldNames.cust_MiddleName:
                        return ((CustomersBO)component).cust_MiddleName;
                    case CustomersBOFieldNames.cust_LastName:
                        return ((CustomersBO)component).cust_LastName;
                    case CustomersBOFieldNames.cust_Suffix:
                        return ((CustomersBO)component).cust_Suffix;
                    case CustomersBOFieldNames.cust_Address1:
                        return ((CustomersBO)component).cust_Address1;
                    case CustomersBOFieldNames.cust_Address2:
                        return ((CustomersBO)component).cust_Address2;
                    case CustomersBOFieldNames.cust_City:
                        return ((CustomersBO)component).cust_City;
                    case CustomersBOFieldNames.cust_State:
                        return ((CustomersBO)component).cust_State;
                    case CustomersBOFieldNames.cust_Postal:
                        return ((CustomersBO)component).cust_Postal;
                    case CustomersBOFieldNames.cust_Country:
                        return ((CustomersBO)component).cust_Country;
                    case CustomersBOFieldNames.cust_Email:
                        return ((CustomersBO)component).cust_Email;
                    case CustomersBOFieldNames.cust_PhoneDay:
                        return ((CustomersBO)component).cust_PhoneDay;
                    case CustomersBOFieldNames.cust_PhoneDayType:
                        return ((CustomersBO)component).cust_PhoneDayType;
                    case CustomersBOFieldNames.cust_PhoneNight:
                        return ((CustomersBO)component).cust_PhoneNight;
                    case CustomersBOFieldNames.cust_PhoneNightType:
                        return ((CustomersBO)component).cust_PhoneNightType;
                    case CustomersBOFieldNames.cust_Created:
                        return ((CustomersBO)component).cust_Created;
                    case CustomersBOFieldNames.cust_Version:
                        return ((CustomersBO)component).cust_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case CustomersBOFieldNames.cust_pk:
                        ((CustomersBO)component).cust_pk = (System.Int32)value;
                        break;
                    case CustomersBOFieldNames.cust_Company:
                        ((CustomersBO)component).cust_Company = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Prefix:
                        ((CustomersBO)component).cust_Prefix = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_FirstName:
                        ((CustomersBO)component).cust_FirstName = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_MiddleName:
                        ((CustomersBO)component).cust_MiddleName = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_LastName:
                        ((CustomersBO)component).cust_LastName = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Suffix:
                        ((CustomersBO)component).cust_Suffix = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Address1:
                        ((CustomersBO)component).cust_Address1 = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Address2:
                        ((CustomersBO)component).cust_Address2 = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_City:
                        ((CustomersBO)component).cust_City = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_State:
                        ((CustomersBO)component).cust_State = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Postal:
                        ((CustomersBO)component).cust_Postal = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Country:
                        ((CustomersBO)component).cust_Country = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_Email:
                        ((CustomersBO)component).cust_Email = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_PhoneDay:
                        ((CustomersBO)component).cust_PhoneDay = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_PhoneDayType:
                        ((CustomersBO)component).cust_PhoneDayType = (PhoneType)value;
                        break;
                    case CustomersBOFieldNames.cust_PhoneNight:
                        ((CustomersBO)component).cust_PhoneNight = (System.String)value;
                        break;
                    case CustomersBOFieldNames.cust_PhoneNightType:
                        ((CustomersBO)component).cust_PhoneNightType = (PhoneType)value;
                        break;
                    case CustomersBOFieldNames.cust_Created:
                        ((CustomersBO)component).cust_Created = (System.DateTime)value;
                        break;
                    case CustomersBOFieldNames.cust_Version:
                        ((CustomersBO)component).cust_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
